#!/bin/sh
PARTITION=Segmentation

exp_name=$1 # split0 - split3
dataset=$2 # pascal coco
gpu=$3
now_exp=$4

if [ $gpu -eq 2 ]; then
  GPU_ID=2,3
elif [ $gpu -eq 1 ]; then
  GPU_ID=3
elif [ $gpu -eq 4 ]; then
  GPU_ID=0,1,2,3
else
  echo "Only 1, 2 and 4 gpu number are supperted"
  exit 1
fi
arch=PI_CLIP
net=resnet50 # vgg resnet50

exp_dir=/data0/akk/exp/${dataset}/${now_exp}/${exp_name}/${net} 
snapshot_dir=${exp_dir}/snapshot
result_dir=${exp_dir}/result
config=config/${dataset}/${dataset}_${exp_name}_${net}_manet.yaml
mkdir -p ${snapshot_dir} ${result_dir}
now=$(date +"%Y%m%d_%H%M%S")
cp test.sh test.py ${config} ${exp_dir}

echo ${arch}
echo ${config}

CUDA_VISIBLE_DEVICES=${GPU_ID} python3 -u test_print.py \
        --config=${config} \
        --arch=${arch} \
        --arch_save=${now_exp} \
        2>&1 | tee ${result_dir}/test-$now.log